import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(6, 9))

# Define grid dimensions
rows, cols = 6, 4
grid_size = 1

# Define colors
colors = {
    'rightl0': 'blue',
    'rightl1': 'green',
    'square0': 'red',
    'square1': 'yellow',
    'clear': 'white'
}

# Define piece positions in the goal state
pieces = {
    'rightl0': 'no constraint',
    'rightl1': 'no constraint',
    'square0': 'no constraint',
    'square1': 'no constraint'
}

# Draw grid
for row in range(rows):
    for col in range(cols):
        # Determine if the cell is in the top three rows
        if row < 3:
            color = colors['clear']
            status = 'clear'
            piece_name = f"f{row}-{col}f"
        else:
            color = colors['clear']
            status = ''
            piece_name = ''
        
        # Draw the rectangle
        rect = patches.Rectangle((col * grid_size, (rows - 1 - row) * grid_size), grid_size, grid_size, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)

        # Add text
        text_color = 'black'
        ax.text(col * grid_size + 0.5 * grid_size, (rows - 1 - row) * grid_size + 0.5 * grid_size, piece_name, ha='center', va='center', color=text_color, fontsize=8, fontweight='bold')

# Add pieces with no constraints
for name, constraint in pieces.items():
    if constraint == 'no constraint':
        # Draw a placeholder rectangle for each piece
        rect = patches.Rectangle((0, 0), grid_size, grid_size, linewidth=3, edgecolor='black', facecolor=colors[name])
        ax.add_patch(rect)
        ax.text(0.5 * grid_size, 0.5 * grid_size, name, ha='center', va='center', color='white', fontsize=8, fontweight='bold')

# Set axis limits and aspect
ax.set_xlim(0, cols * grid_size)
ax.set_ylim(0, rows * grid_size)
ax.set_aspect('equal')

# Remove axes
ax.axis('off')

# Add legend
legend_elements = [
    patches.Patch(facecolor='blue', edgecolor='black', label='rightl0: no constraint'),
    patches.Patch(facecolor='green', edgecolor='black', label='rightl1: no constraint'),
    patches.Patch(facecolor='red', edgecolor='black', label='square0: no constraint'),
    patches.Patch(facecolor='yellow', edgecolor='black', label='square1: no constraint'),
    patches.Patch(facecolor='white', edgecolor='black', label='clear: clear')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.2, 1))

# Add text description for no constraint pieces
ax.text(0, -1, "Note: Pieces 'rightl0', 'rightl1', 'square0', and 'square1' have no constraints on their positions.", fontsize=8, ha='left')

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()